<?php

namespace Stripe\Util;

class EventNotificationTypes
{
    const v2EventMapping = [
        // The beginning of the section generated from our OpenAPI spec
        \Stripe\Events\V1AccountUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1AccountUpdatedEventNotification::class,
        \Stripe\Events\V1ApplicationFeeCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ApplicationFeeCreatedEventNotification::class,
        \Stripe\Events\V1ApplicationFeeRefundedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ApplicationFeeRefundedEventNotification::class,
        \Stripe\Events\V1BillingMeterErrorReportTriggeredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1BillingMeterErrorReportTriggeredEventNotification::class,
        \Stripe\Events\V1BillingMeterNoMeterFoundEventNotification::LOOKUP_TYPE => \Stripe\Events\V1BillingMeterNoMeterFoundEventNotification::class,
        \Stripe\Events\V1BillingPortalConfigurationCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1BillingPortalConfigurationCreatedEventNotification::class,
        \Stripe\Events\V1BillingPortalConfigurationUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1BillingPortalConfigurationUpdatedEventNotification::class,
        \Stripe\Events\V1CapabilityUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CapabilityUpdatedEventNotification::class,
        \Stripe\Events\V1ChargeCapturedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeCapturedEventNotification::class,
        \Stripe\Events\V1ChargeDisputeClosedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeDisputeClosedEventNotification::class,
        \Stripe\Events\V1ChargeDisputeCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeDisputeCreatedEventNotification::class,
        \Stripe\Events\V1ChargeDisputeFundsReinstatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeDisputeFundsReinstatedEventNotification::class,
        \Stripe\Events\V1ChargeDisputeFundsWithdrawnEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeDisputeFundsWithdrawnEventNotification::class,
        \Stripe\Events\V1ChargeDisputeUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeDisputeUpdatedEventNotification::class,
        \Stripe\Events\V1ChargeExpiredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeExpiredEventNotification::class,
        \Stripe\Events\V1ChargeFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeFailedEventNotification::class,
        \Stripe\Events\V1ChargePendingEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargePendingEventNotification::class,
        \Stripe\Events\V1ChargeRefundUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeRefundUpdatedEventNotification::class,
        \Stripe\Events\V1ChargeRefundedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeRefundedEventNotification::class,
        \Stripe\Events\V1ChargeSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeSucceededEventNotification::class,
        \Stripe\Events\V1ChargeUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ChargeUpdatedEventNotification::class,
        \Stripe\Events\V1CheckoutSessionAsyncPaymentFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CheckoutSessionAsyncPaymentFailedEventNotification::class,
        \Stripe\Events\V1CheckoutSessionAsyncPaymentSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CheckoutSessionAsyncPaymentSucceededEventNotification::class,
        \Stripe\Events\V1CheckoutSessionCompletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CheckoutSessionCompletedEventNotification::class,
        \Stripe\Events\V1CheckoutSessionExpiredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CheckoutSessionExpiredEventNotification::class,
        \Stripe\Events\V1ClimateOrderCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateOrderCanceledEventNotification::class,
        \Stripe\Events\V1ClimateOrderCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateOrderCreatedEventNotification::class,
        \Stripe\Events\V1ClimateOrderDelayedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateOrderDelayedEventNotification::class,
        \Stripe\Events\V1ClimateOrderDeliveredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateOrderDeliveredEventNotification::class,
        \Stripe\Events\V1ClimateOrderProductSubstitutedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateOrderProductSubstitutedEventNotification::class,
        \Stripe\Events\V1ClimateProductCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateProductCreatedEventNotification::class,
        \Stripe\Events\V1ClimateProductPricingUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ClimateProductPricingUpdatedEventNotification::class,
        \Stripe\Events\V1CouponCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CouponCreatedEventNotification::class,
        \Stripe\Events\V1CouponDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CouponDeletedEventNotification::class,
        \Stripe\Events\V1CouponUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CouponUpdatedEventNotification::class,
        \Stripe\Events\V1CreditNoteCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CreditNoteCreatedEventNotification::class,
        \Stripe\Events\V1CreditNoteUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CreditNoteUpdatedEventNotification::class,
        \Stripe\Events\V1CreditNoteVoidedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CreditNoteVoidedEventNotification::class,
        \Stripe\Events\V1CustomerCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerCreatedEventNotification::class,
        \Stripe\Events\V1CustomerDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerDeletedEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionCreatedEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionDeletedEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionPausedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionPausedEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionPendingUpdateAppliedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionPendingUpdateAppliedEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionPendingUpdateExpiredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionPendingUpdateExpiredEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionResumedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionResumedEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionTrialWillEndEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionTrialWillEndEventNotification::class,
        \Stripe\Events\V1CustomerSubscriptionUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerSubscriptionUpdatedEventNotification::class,
        \Stripe\Events\V1CustomerTaxIdCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerTaxIdCreatedEventNotification::class,
        \Stripe\Events\V1CustomerTaxIdDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerTaxIdDeletedEventNotification::class,
        \Stripe\Events\V1CustomerTaxIdUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerTaxIdUpdatedEventNotification::class,
        \Stripe\Events\V1CustomerUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1CustomerUpdatedEventNotification::class,
        \Stripe\Events\V1FileCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FileCreatedEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountCreatedEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountDeactivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountDeactivatedEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountDisconnectedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountDisconnectedEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountReactivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountReactivatedEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountRefreshedBalanceEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountRefreshedBalanceEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountRefreshedOwnershipEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountRefreshedOwnershipEventNotification::class,
        \Stripe\Events\V1FinancialConnectionsAccountRefreshedTransactionsEventNotification::LOOKUP_TYPE => \Stripe\Events\V1FinancialConnectionsAccountRefreshedTransactionsEventNotification::class,
        \Stripe\Events\V1IdentityVerificationSessionCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IdentityVerificationSessionCanceledEventNotification::class,
        \Stripe\Events\V1IdentityVerificationSessionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IdentityVerificationSessionCreatedEventNotification::class,
        \Stripe\Events\V1IdentityVerificationSessionProcessingEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IdentityVerificationSessionProcessingEventNotification::class,
        \Stripe\Events\V1IdentityVerificationSessionRedactedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IdentityVerificationSessionRedactedEventNotification::class,
        \Stripe\Events\V1IdentityVerificationSessionRequiresInputEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IdentityVerificationSessionRequiresInputEventNotification::class,
        \Stripe\Events\V1IdentityVerificationSessionVerifiedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IdentityVerificationSessionVerifiedEventNotification::class,
        \Stripe\Events\V1InvoiceCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceCreatedEventNotification::class,
        \Stripe\Events\V1InvoiceDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceDeletedEventNotification::class,
        \Stripe\Events\V1InvoiceFinalizationFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceFinalizationFailedEventNotification::class,
        \Stripe\Events\V1InvoiceFinalizedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceFinalizedEventNotification::class,
        \Stripe\Events\V1InvoiceMarkedUncollectibleEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceMarkedUncollectibleEventNotification::class,
        \Stripe\Events\V1InvoiceOverdueEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceOverdueEventNotification::class,
        \Stripe\Events\V1InvoiceOverpaidEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceOverpaidEventNotification::class,
        \Stripe\Events\V1InvoicePaidEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoicePaidEventNotification::class,
        \Stripe\Events\V1InvoicePaymentActionRequiredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoicePaymentActionRequiredEventNotification::class,
        \Stripe\Events\V1InvoicePaymentFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoicePaymentFailedEventNotification::class,
        \Stripe\Events\V1InvoicePaymentSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoicePaymentSucceededEventNotification::class,
        \Stripe\Events\V1InvoiceSentEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceSentEventNotification::class,
        \Stripe\Events\V1InvoiceUpcomingEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceUpcomingEventNotification::class,
        \Stripe\Events\V1InvoiceUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceUpdatedEventNotification::class,
        \Stripe\Events\V1InvoiceVoidedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceVoidedEventNotification::class,
        \Stripe\Events\V1InvoiceWillBeDueEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceWillBeDueEventNotification::class,
        \Stripe\Events\V1InvoicePaymentPaidEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoicePaymentPaidEventNotification::class,
        \Stripe\Events\V1InvoiceitemCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceitemCreatedEventNotification::class,
        \Stripe\Events\V1InvoiceitemDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1InvoiceitemDeletedEventNotification::class,
        \Stripe\Events\V1IssuingAuthorizationCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingAuthorizationCreatedEventNotification::class,
        \Stripe\Events\V1IssuingAuthorizationRequestEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingAuthorizationRequestEventNotification::class,
        \Stripe\Events\V1IssuingAuthorizationUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingAuthorizationUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingCardCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingCardCreatedEventNotification::class,
        \Stripe\Events\V1IssuingCardUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingCardUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingCardholderCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingCardholderCreatedEventNotification::class,
        \Stripe\Events\V1IssuingCardholderUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingCardholderUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingDisputeClosedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingDisputeClosedEventNotification::class,
        \Stripe\Events\V1IssuingDisputeCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingDisputeCreatedEventNotification::class,
        \Stripe\Events\V1IssuingDisputeFundsReinstatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingDisputeFundsReinstatedEventNotification::class,
        \Stripe\Events\V1IssuingDisputeFundsRescindedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingDisputeFundsRescindedEventNotification::class,
        \Stripe\Events\V1IssuingDisputeSubmittedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingDisputeSubmittedEventNotification::class,
        \Stripe\Events\V1IssuingDisputeUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingDisputeUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingPersonalizationDesignActivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingPersonalizationDesignActivatedEventNotification::class,
        \Stripe\Events\V1IssuingPersonalizationDesignDeactivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingPersonalizationDesignDeactivatedEventNotification::class,
        \Stripe\Events\V1IssuingPersonalizationDesignRejectedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingPersonalizationDesignRejectedEventNotification::class,
        \Stripe\Events\V1IssuingPersonalizationDesignUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingPersonalizationDesignUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingTokenCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingTokenCreatedEventNotification::class,
        \Stripe\Events\V1IssuingTokenUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingTokenUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingTransactionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingTransactionCreatedEventNotification::class,
        \Stripe\Events\V1IssuingTransactionPurchaseDetailsReceiptUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingTransactionPurchaseDetailsReceiptUpdatedEventNotification::class,
        \Stripe\Events\V1IssuingTransactionUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1IssuingTransactionUpdatedEventNotification::class,
        \Stripe\Events\V1MandateUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1MandateUpdatedEventNotification::class,
        \Stripe\Events\V1PaymentIntentAmountCapturableUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentAmountCapturableUpdatedEventNotification::class,
        \Stripe\Events\V1PaymentIntentCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentCanceledEventNotification::class,
        \Stripe\Events\V1PaymentIntentCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentCreatedEventNotification::class,
        \Stripe\Events\V1PaymentIntentPartiallyFundedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentPartiallyFundedEventNotification::class,
        \Stripe\Events\V1PaymentIntentPaymentFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentPaymentFailedEventNotification::class,
        \Stripe\Events\V1PaymentIntentProcessingEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentProcessingEventNotification::class,
        \Stripe\Events\V1PaymentIntentRequiresActionEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentRequiresActionEventNotification::class,
        \Stripe\Events\V1PaymentIntentSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentIntentSucceededEventNotification::class,
        \Stripe\Events\V1PaymentLinkCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentLinkCreatedEventNotification::class,
        \Stripe\Events\V1PaymentLinkUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentLinkUpdatedEventNotification::class,
        \Stripe\Events\V1PaymentMethodAttachedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentMethodAttachedEventNotification::class,
        \Stripe\Events\V1PaymentMethodAutomaticallyUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentMethodAutomaticallyUpdatedEventNotification::class,
        \Stripe\Events\V1PaymentMethodDetachedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentMethodDetachedEventNotification::class,
        \Stripe\Events\V1PaymentMethodUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PaymentMethodUpdatedEventNotification::class,
        \Stripe\Events\V1PayoutCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PayoutCanceledEventNotification::class,
        \Stripe\Events\V1PayoutCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PayoutCreatedEventNotification::class,
        \Stripe\Events\V1PayoutFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PayoutFailedEventNotification::class,
        \Stripe\Events\V1PayoutPaidEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PayoutPaidEventNotification::class,
        \Stripe\Events\V1PayoutReconciliationCompletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PayoutReconciliationCompletedEventNotification::class,
        \Stripe\Events\V1PayoutUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PayoutUpdatedEventNotification::class,
        \Stripe\Events\V1PersonCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PersonCreatedEventNotification::class,
        \Stripe\Events\V1PersonDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PersonDeletedEventNotification::class,
        \Stripe\Events\V1PersonUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PersonUpdatedEventNotification::class,
        \Stripe\Events\V1PlanCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PlanCreatedEventNotification::class,
        \Stripe\Events\V1PlanDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PlanDeletedEventNotification::class,
        \Stripe\Events\V1PlanUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PlanUpdatedEventNotification::class,
        \Stripe\Events\V1PriceCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PriceCreatedEventNotification::class,
        \Stripe\Events\V1PriceDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PriceDeletedEventNotification::class,
        \Stripe\Events\V1PriceUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PriceUpdatedEventNotification::class,
        \Stripe\Events\V1ProductCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ProductCreatedEventNotification::class,
        \Stripe\Events\V1ProductDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ProductDeletedEventNotification::class,
        \Stripe\Events\V1ProductUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ProductUpdatedEventNotification::class,
        \Stripe\Events\V1PromotionCodeCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PromotionCodeCreatedEventNotification::class,
        \Stripe\Events\V1PromotionCodeUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1PromotionCodeUpdatedEventNotification::class,
        \Stripe\Events\V1QuoteAcceptedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1QuoteAcceptedEventNotification::class,
        \Stripe\Events\V1QuoteCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1QuoteCanceledEventNotification::class,
        \Stripe\Events\V1QuoteCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1QuoteCreatedEventNotification::class,
        \Stripe\Events\V1QuoteFinalizedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1QuoteFinalizedEventNotification::class,
        \Stripe\Events\V1RadarEarlyFraudWarningCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1RadarEarlyFraudWarningCreatedEventNotification::class,
        \Stripe\Events\V1RadarEarlyFraudWarningUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1RadarEarlyFraudWarningUpdatedEventNotification::class,
        \Stripe\Events\V1RefundCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1RefundCreatedEventNotification::class,
        \Stripe\Events\V1RefundFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1RefundFailedEventNotification::class,
        \Stripe\Events\V1RefundUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1RefundUpdatedEventNotification::class,
        \Stripe\Events\V1ReviewClosedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ReviewClosedEventNotification::class,
        \Stripe\Events\V1ReviewOpenedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1ReviewOpenedEventNotification::class,
        \Stripe\Events\V1SetupIntentCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SetupIntentCanceledEventNotification::class,
        \Stripe\Events\V1SetupIntentCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SetupIntentCreatedEventNotification::class,
        \Stripe\Events\V1SetupIntentRequiresActionEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SetupIntentRequiresActionEventNotification::class,
        \Stripe\Events\V1SetupIntentSetupFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SetupIntentSetupFailedEventNotification::class,
        \Stripe\Events\V1SetupIntentSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SetupIntentSucceededEventNotification::class,
        \Stripe\Events\V1SigmaScheduledQueryRunCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SigmaScheduledQueryRunCreatedEventNotification::class,
        \Stripe\Events\V1SourceCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SourceCanceledEventNotification::class,
        \Stripe\Events\V1SourceChargeableEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SourceChargeableEventNotification::class,
        \Stripe\Events\V1SourceFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SourceFailedEventNotification::class,
        \Stripe\Events\V1SourceRefundAttributesRequiredEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SourceRefundAttributesRequiredEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleAbortedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleAbortedEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleCanceledEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleCompletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleCompletedEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleCreatedEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleExpiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleExpiringEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleReleasedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleReleasedEventNotification::class,
        \Stripe\Events\V1SubscriptionScheduleUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1SubscriptionScheduleUpdatedEventNotification::class,
        \Stripe\Events\V1TaxRateCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TaxRateCreatedEventNotification::class,
        \Stripe\Events\V1TaxRateUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TaxRateUpdatedEventNotification::class,
        \Stripe\Events\V1TerminalReaderActionFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TerminalReaderActionFailedEventNotification::class,
        \Stripe\Events\V1TerminalReaderActionSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TerminalReaderActionSucceededEventNotification::class,
        \Stripe\Events\V1TerminalReaderActionUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TerminalReaderActionUpdatedEventNotification::class,
        \Stripe\Events\V1TestHelpersTestClockAdvancingEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TestHelpersTestClockAdvancingEventNotification::class,
        \Stripe\Events\V1TestHelpersTestClockCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TestHelpersTestClockCreatedEventNotification::class,
        \Stripe\Events\V1TestHelpersTestClockDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TestHelpersTestClockDeletedEventNotification::class,
        \Stripe\Events\V1TestHelpersTestClockInternalFailureEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TestHelpersTestClockInternalFailureEventNotification::class,
        \Stripe\Events\V1TestHelpersTestClockReadyEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TestHelpersTestClockReadyEventNotification::class,
        \Stripe\Events\V1TopupCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TopupCanceledEventNotification::class,
        \Stripe\Events\V1TopupCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TopupCreatedEventNotification::class,
        \Stripe\Events\V1TopupFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TopupFailedEventNotification::class,
        \Stripe\Events\V1TopupReversedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TopupReversedEventNotification::class,
        \Stripe\Events\V1TopupSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TopupSucceededEventNotification::class,
        \Stripe\Events\V1TransferCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TransferCreatedEventNotification::class,
        \Stripe\Events\V1TransferReversedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TransferReversedEventNotification::class,
        \Stripe\Events\V1TransferUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V1TransferUpdatedEventNotification::class,
        \Stripe\Events\V2BillingBillSettingUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingBillSettingUpdatedEventNotification::class,
        \Stripe\Events\V2BillingCadenceBilledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingCadenceBilledEventNotification::class,
        \Stripe\Events\V2BillingCadenceCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingCadenceCanceledEventNotification::class,
        \Stripe\Events\V2BillingCadenceCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingCadenceCreatedEventNotification::class,
        \Stripe\Events\V2BillingLicenseFeeCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingLicenseFeeCreatedEventNotification::class,
        \Stripe\Events\V2BillingLicenseFeeUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingLicenseFeeUpdatedEventNotification::class,
        \Stripe\Events\V2BillingLicenseFeeVersionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingLicenseFeeVersionCreatedEventNotification::class,
        \Stripe\Events\V2BillingLicensedItemCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingLicensedItemCreatedEventNotification::class,
        \Stripe\Events\V2BillingLicensedItemUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingLicensedItemUpdatedEventNotification::class,
        \Stripe\Events\V2BillingMeteredItemCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingMeteredItemCreatedEventNotification::class,
        \Stripe\Events\V2BillingMeteredItemUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingMeteredItemUpdatedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanCreatedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanUpdatedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanComponentCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanComponentCreatedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanComponentUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanComponentUpdatedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionAwaitingCustomerActionEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionAwaitingCustomerActionEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionCurrentEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionCurrentEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionPastDueEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionPastDueEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionPausedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionPausedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionUnpaidEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionCollectionUnpaidEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionServicingActivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionServicingActivatedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionServicingCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionServicingCanceledEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanSubscriptionServicingPausedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanSubscriptionServicingPausedEventNotification::class,
        \Stripe\Events\V2BillingPricingPlanVersionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingPricingPlanVersionCreatedEventNotification::class,
        \Stripe\Events\V2BillingRateCardCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardCreatedEventNotification::class,
        \Stripe\Events\V2BillingRateCardUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardUpdatedEventNotification::class,
        \Stripe\Events\V2BillingRateCardRateCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardRateCreatedEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionActivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionActivatedEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionCanceledEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionCollectionAwaitingCustomerActionEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionCollectionAwaitingCustomerActionEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionCollectionCurrentEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionCollectionCurrentEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionCollectionPastDueEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionCollectionPastDueEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionCollectionPausedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionCollectionPausedEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionCollectionUnpaidEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionCollectionUnpaidEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionServicingActivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionServicingActivatedEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionServicingCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionServicingCanceledEventNotification::class,
        \Stripe\Events\V2BillingRateCardSubscriptionServicingPausedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardSubscriptionServicingPausedEventNotification::class,
        \Stripe\Events\V2BillingRateCardVersionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2BillingRateCardVersionCreatedEventNotification::class,
        \Stripe\Events\V2CoreAccountClosedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountClosedEventNotification::class,
        \Stripe\Events\V2CoreAccountCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountCreatedEventNotification::class,
        \Stripe\Events\V2CoreAccountUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationCustomerCapabilityStatusUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationCustomerCapabilityStatusUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationCustomerUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationCustomerUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationMerchantCapabilityStatusUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationMerchantCapabilityStatusUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationMerchantUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationMerchantUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationRecipientCapabilityStatusUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationRecipientCapabilityStatusUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationRecipientUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationRecipientUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationStorerCapabilityStatusUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationStorerCapabilityStatusUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingConfigurationStorerUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingConfigurationStorerUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingDefaultsUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingDefaultsUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingIdentityUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingIdentityUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountIncludingRequirementsUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountIncludingRequirementsUpdatedEventNotification::class,
        \Stripe\Events\V2CoreAccountLinkReturnedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountLinkReturnedEventNotification::class,
        \Stripe\Events\V2CoreAccountPersonCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountPersonCreatedEventNotification::class,
        \Stripe\Events\V2CoreAccountPersonDeletedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountPersonDeletedEventNotification::class,
        \Stripe\Events\V2CoreAccountPersonUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreAccountPersonUpdatedEventNotification::class,
        \Stripe\Events\V2CoreClaimableSandboxClaimedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreClaimableSandboxClaimedEventNotification::class,
        \Stripe\Events\V2CoreClaimableSandboxCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreClaimableSandboxCreatedEventNotification::class,
        \Stripe\Events\V2CoreClaimableSandboxExpiredEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreClaimableSandboxExpiredEventNotification::class,
        \Stripe\Events\V2CoreClaimableSandboxExpiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreClaimableSandboxExpiringEventNotification::class,
        \Stripe\Events\V2CoreClaimableSandboxSandboxDetailsOwnerAccountUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreClaimableSandboxSandboxDetailsOwnerAccountUpdatedEventNotification::class,
        \Stripe\Events\V2CoreEventDestinationPingEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreEventDestinationPingEventNotification::class,
        \Stripe\Events\V2CoreHealthApiErrorFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthApiErrorFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthApiErrorResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthApiErrorResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthApiLatencyFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthApiLatencyFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthApiLatencyResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthApiLatencyResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthAuthorizationRateDropFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthAuthorizationRateDropFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthAuthorizationRateDropResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthAuthorizationRateDropResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthEventGenerationFailureResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthEventGenerationFailureResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthFraudRateIncreasedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthFraudRateIncreasedEventNotification::class,
        \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestErrorsFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestErrorsFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestErrorsResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestErrorsResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestTimeoutFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestTimeoutFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestTimeoutResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthIssuingAuthorizationRequestTimeoutResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthPaymentMethodErrorFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthPaymentMethodErrorFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthPaymentMethodErrorResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthPaymentMethodErrorResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthTrafficVolumeDropFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthTrafficVolumeDropFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthTrafficVolumeDropResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthTrafficVolumeDropResolvedEventNotification::class,
        \Stripe\Events\V2CoreHealthWebhookLatencyFiringEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthWebhookLatencyFiringEventNotification::class,
        \Stripe\Events\V2CoreHealthWebhookLatencyResolvedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2CoreHealthWebhookLatencyResolvedEventNotification::class,
        \Stripe\Events\V2MoneyManagementAdjustmentCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementAdjustmentCreatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementFinancialAccountCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementFinancialAccountCreatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementFinancialAccountUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementFinancialAccountUpdatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementFinancialAddressActivatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementFinancialAddressActivatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementFinancialAddressFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementFinancialAddressFailedEventNotification::class,
        \Stripe\Events\V2MoneyManagementInboundTransferAvailableEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementInboundTransferAvailableEventNotification::class,
        \Stripe\Events\V2MoneyManagementInboundTransferBankDebitFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementInboundTransferBankDebitFailedEventNotification::class,
        \Stripe\Events\V2MoneyManagementInboundTransferBankDebitProcessingEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementInboundTransferBankDebitProcessingEventNotification::class,
        \Stripe\Events\V2MoneyManagementInboundTransferBankDebitQueuedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementInboundTransferBankDebitQueuedEventNotification::class,
        \Stripe\Events\V2MoneyManagementInboundTransferBankDebitReturnedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementInboundTransferBankDebitReturnedEventNotification::class,
        \Stripe\Events\V2MoneyManagementInboundTransferBankDebitSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementInboundTransferBankDebitSucceededEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundPaymentCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundPaymentCanceledEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundPaymentCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundPaymentCreatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundPaymentFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundPaymentFailedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundPaymentPostedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundPaymentPostedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundPaymentReturnedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundPaymentReturnedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundPaymentUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundPaymentUpdatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundTransferCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundTransferCanceledEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundTransferCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundTransferCreatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundTransferFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundTransferFailedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundTransferPostedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundTransferPostedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundTransferReturnedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundTransferReturnedEventNotification::class,
        \Stripe\Events\V2MoneyManagementOutboundTransferUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementOutboundTransferUpdatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementPayoutMethodUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementPayoutMethodUpdatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedCreditAvailableEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedCreditAvailableEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedCreditFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedCreditFailedEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedCreditReturnedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedCreditReturnedEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedCreditSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedCreditSucceededEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedDebitCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedDebitCanceledEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedDebitFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedDebitFailedEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedDebitPendingEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedDebitPendingEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedDebitSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedDebitSucceededEventNotification::class,
        \Stripe\Events\V2MoneyManagementReceivedDebitUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementReceivedDebitUpdatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementRecipientVerificationCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementRecipientVerificationCreatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementRecipientVerificationUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementRecipientVerificationUpdatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementTransactionCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementTransactionCreatedEventNotification::class,
        \Stripe\Events\V2MoneyManagementTransactionUpdatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2MoneyManagementTransactionUpdatedEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentAuthorizationAttemptFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentAuthorizationAttemptFailedEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentAuthorizationAttemptStartedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentAuthorizationAttemptStartedEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentCanceledEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentCanceledEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentCreatedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentCreatedEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentFailedEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentFailedEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentRequiresCaptureEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentRequiresCaptureEventNotification::class,
        \Stripe\Events\V2PaymentsOffSessionPaymentSucceededEventNotification::LOOKUP_TYPE => \Stripe\Events\V2PaymentsOffSessionPaymentSucceededEventNotification::class,
        // The end of the section generated from our OpenAPI spec
    ];
}
